function test_suite = testIoFolder %#ok<*STOUT>
% Test the I/O folder setting
initTestSuite;

function self = setup %#ok<*DEFNU>
absolute_name = tempname;
relative_name = 'Yoopers';

% Delete the I/O folder, if it exists
warning('off','MATLAB:RMDIR:RemovedFromPat')
status = rmdir(absolute_name); %#ok<NASGU>
status = rmdir(relative_name); %#ok<NASGU>
warning('on','MATLAB:RMDIR:RemovedFromPat')

p_absolute = BertiniLab('Bertini_io_folder',absolute_name);
p_relative = BertiniLab('Bertini_io_folder',relative_name);
self.absolute_name = absolute_name;
self.relative_name = relative_name;
self.p_absolute = p_absolute;
self.p_relative = p_relative;

%======= Absolute path ================
function testSetAbsolute(self)
% When Bertini_io_folder is changed, the folder should be created.
fname = self.p_absolute.io_folder;
assertTrue(exist(fname,'dir')==7)

function testMakeInputAbsolute(self)
% Just test to see that the file is where it should be.
p = self.p_absolute;
p.function_def = polysym({'x'});
p.variable_group = polysym('x');
make_input_file(p);
assertTrue(exist(fullfile(self.absolute_name,'input'),'file')==2)

%======= Relative path ================
function testSetRelative(self)
% When Bertini_io_folder is changed, the folder should be created.
fname = self.p_absolute.io_folder;
assertTrue(exist(fname,'dir')==7)

function testMakeInputRelative(self)
% Just test to see that the file is where it should be.
p = self.p_relative;
p.function_def = polysym({'x'});
p.variable_group = polysym('x');
make_input_file(p);
assertTrue(exist(fullfile(self.relative_name,'input'),'file')==2)

function teardown(self)
warning('off','MATLAB:RMDIR:RemovedFromPat')
status = rmdir(self.absolute_name,'s'); %#ok<NASGU>
status = rmdir(self.relative_name,'s'); %#ok<NASGU>
warning('on','MATLAB:RMDIR:RemovedFromPat')